<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('name');

    public function jobApplications()
    {
        return $this->hasMany('App\Models\JobApplications');
    }

    public function districts()
    {
        return $this->hasMany('App\Models\District');
    }

    public function trainApplicationSchools()
    {
        return $this->hasMany('App\Models\TrainingApplication', 'school_city_id');
    }

}